/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property;

import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.CEObjectInfoCache;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWDesignerPropertyPane;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.event.VWMapChangeEventNotifier;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.event.VWPropertyChangeEventNotifier;
import filenet.vw.toolkit.design.property.event.VWSelectionChangeEventNotifier;
import filenet.vw.toolkit.design.property.event.VWTableActionEventNotifier;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.VWToolbarActionNotifier;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JRootPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VWAuthPropertyData
implements IVWPropertyData {
    public static final String F_UNDERSCORE = "F_";
    public static final int PROPERTIES_LOCAL = 1;
    public static final int PROPERTIES_INHERITED = 2;
    private VWMapChangeEventNotifier m_mapChangeEventNotifier = null;
    private VWPropertyChangeEventNotifier m_propertyChangeEventNotifier = null;
    private VWSelectionChangeEventNotifier m_selectionChangeEventNotifier = null;
    private VWTableActionEventNotifier m_tableActionEventNotifier = null;
    private VWToolbarActionNotifier m_toolbarActionNotifier = null;
    private VWMapCache m_mapCache = null;
    private VWFieldDefinition[] m_fieldDefs = null;
    private VWMilestoneDefinition[] m_milestoneDefs = null;
    private VWPartnerLinkDefinition[] m_partnerLinkDefs = null;
    private VWRuleSetDefinition[] m_ruleSetDefs = null;
    private VWSchema[] m_schemaDefs = null;
    private VWWebServiceUtils m_webServiceUtils = null;
    private VWWorkflowDefinition m_workflowDefinition = null;
    private VWWorkflowDefinition m_baseWorkflowDefinition = null;
    private boolean m_isCurrentMapEditable = true;
    private boolean m_bShowInheritedProperties = true;
    private VWDesignerCoreData m_designerCoreData = null;
    private VWDesignerPropertyPane m_workflowPropertyPane = null;

    public VWAuthPropertyData(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
    }

    public boolean getIsDirty() {
        return this.m_designerCoreData.getProcessMenuHelper().getIsCollectionDirty();
    }

    public void setDirty() {
        this.m_designerCoreData.getProcessMenuHelper().setCollectionDirty();
    }

    public boolean getAreRulesEnabled() {
        try {
            if (this.getVWSession() != null) {
                return this.getVWSession().checkSystemWideFlagSetting(1024);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public boolean getAllowAsynchronousRules() {
        try {
            if (this.getVWSession() != null) {
                return this.getVWSession().checkSystemWideFlagSetting(2048);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public boolean getShowInheritedProperties() {
        return this.m_bShowInheritedProperties;
    }

    public void setShowInheritedProperties(boolean bShow) {
        this.m_bShowInheritedProperties = bShow;
        this.getMapChangeEventNotifier().notifyMapChange(103);
    }

    public boolean isFieldName(String name) {
        VWFieldDefinition fieldDef = this.getField(name);
        return fieldDef != null;
    }

    public VWFieldDefinition getField(String name) {
        return this.getField(name, 3);
    }

    public VWFieldDefinition getField(String name, int nFlags) {
        VWFieldDefinition fieldDef = null;
        if ((nFlags & 1) != 0 && this.m_workflowDefinition != null && (fieldDef = this.getFieldFromWorkflow(this.m_workflowDefinition, name)) != null) {
            return fieldDef;
        }
        if ((nFlags & 2) != 0 && this.m_baseWorkflowDefinition != null) {
            fieldDef = this.getFieldFromWorkflow(this.m_baseWorkflowDefinition, name);
        }
        return fieldDef;
    }

    @Override
    public VWFieldDefinition[] getFields() {
        if (this.m_fieldDefs == null) {
            int nFlags = 1;
            if (this.m_bShowInheritedProperties) {
                nFlags |= 2;
            }
            this.m_fieldDefs = this.getFields(nFlags);
        }
        return this.m_fieldDefs;
    }

    public VWFieldDefinition[] getFields(int nFlags) {
        Vector<VWFieldDefinition> fieldList = new Vector<VWFieldDefinition>();
        if ((nFlags & 1) != 0 && this.m_workflowDefinition != null) {
            this.getFieldsFromWorkflow(this.m_workflowDefinition, fieldList);
        }
        if ((nFlags & 2) != 0 && this.m_baseWorkflowDefinition != null) {
            this.getFieldsFromWorkflow(this.m_baseWorkflowDefinition, fieldList);
        }
        Object[] fieldDefs = null;
        if (fieldList != null && fieldList.size() > 0) {
            fieldDefs = new VWFieldDefinition[fieldList.size()];
            fieldList.copyInto(fieldDefs);
        }
        return fieldDefs;
    }

    public void resetFieldCache() {
        this.m_fieldDefs = null;
    }

    public VWMilestoneDefinition getMilestone(String name) {
        VWMilestoneDefinition milestoneDef = null;
        if (this.m_workflowDefinition != null && (milestoneDef = this.getMilestoneFromWorkflow(this.m_workflowDefinition, name)) != null) {
            return milestoneDef;
        }
        if (this.m_baseWorkflowDefinition != null) {
            milestoneDef = this.getMilestoneFromWorkflow(this.m_baseWorkflowDefinition, name);
        }
        return milestoneDef;
    }

    public VWMilestoneDefinition[] getMilestones() {
        if (this.m_milestoneDefs == null) {
            int nFlags = 1;
            if (this.m_bShowInheritedProperties) {
                nFlags |= 2;
            }
            this.m_milestoneDefs = this.getMilestones(nFlags);
        }
        return this.m_milestoneDefs;
    }

    public VWMilestoneDefinition[] getMilestones(int nFlags) {
        Vector<VWMilestoneDefinition> milestoneList = new Vector<VWMilestoneDefinition>();
        if ((nFlags & 2) != 0 && this.m_baseWorkflowDefinition != null) {
            this.getMilestonesFromWorkflow(this.m_baseWorkflowDefinition, milestoneList);
        }
        if ((nFlags & 1) != 0 && this.m_workflowDefinition != null) {
            this.getMilestonesFromWorkflow(this.m_workflowDefinition, milestoneList);
        }
        Object[] milestoneDefs = null;
        if (milestoneList != null && milestoneList.size() > 0) {
            milestoneDefs = new VWMilestoneDefinition[milestoneList.size()];
            milestoneList.copyInto(milestoneDefs);
        }
        return milestoneDefs;
    }

    public void resetMilestoneCache() {
        this.m_milestoneDefs = null;
    }

    public VWPartnerLinkDefinition getPartnerLink(String name) {
        VWPartnerLinkDefinition partnerLinkDef = null;
        if (this.m_workflowDefinition != null && (partnerLinkDef = this.getPartnerLinkFromWorkflow(this.m_workflowDefinition, name)) != null) {
            return partnerLinkDef;
        }
        if (this.m_baseWorkflowDefinition != null) {
            partnerLinkDef = this.getPartnerLinkFromWorkflow(this.m_baseWorkflowDefinition, name);
        }
        return partnerLinkDef;
    }

    public VWPartnerLinkDefinition[] getPartnerLinks() {
        if (this.m_partnerLinkDefs == null) {
            int nFlags = 1;
            if (this.m_bShowInheritedProperties) {
                nFlags |= 2;
            }
            this.m_partnerLinkDefs = this.getPartnerLinks(nFlags);
        }
        return this.m_partnerLinkDefs;
    }

    public VWPartnerLinkDefinition[] getPartnerLinks(int nFlags) {
        Vector<VWPartnerLinkDefinition> partnerLinkList = new Vector<VWPartnerLinkDefinition>();
        if ((nFlags & 2) != 0 && this.m_baseWorkflowDefinition != null) {
            this.getPartnerLinksFromWorkflow(this.m_baseWorkflowDefinition, partnerLinkList);
        }
        if ((nFlags & 1) != 0 && this.m_workflowDefinition != null) {
            this.getPartnerLinksFromWorkflow(this.m_workflowDefinition, partnerLinkList);
        }
        Object[] partnerLinkDefs = null;
        if (partnerLinkList != null && partnerLinkList.size() > 0) {
            partnerLinkDefs = new VWPartnerLinkDefinition[partnerLinkList.size()];
            partnerLinkList.copyInto(partnerLinkDefs);
        }
        return partnerLinkDefs;
    }

    public void resetPartnerLinkCache() {
        this.m_partnerLinkDefs = null;
    }

    public VWRuleSetDefinition getRuleSet(String name) {
        VWRuleSetDefinition ruleSetDef = null;
        if (this.m_workflowDefinition != null && (ruleSetDef = this.getRuleSetFromWorkflow(this.m_workflowDefinition, name)) != null) {
            return ruleSetDef;
        }
        if (this.m_baseWorkflowDefinition != null) {
            ruleSetDef = this.getRuleSetFromWorkflow(this.m_baseWorkflowDefinition, name);
        }
        return ruleSetDef;
    }

    public VWRuleSetDefinition[] getRuleSetsByName(String[] names) {
        if (names != null) {
            Vector<VWRuleSetDefinition> ruleSetDefList = new Vector<VWRuleSetDefinition>();
            for (int i = 0; i < names.length; ++i) {
                VWRuleSetDefinition ruleSetDef = this.getRuleSet(names[i]);
                if (ruleSetDef == null) continue;
                ruleSetDefList.addElement(ruleSetDef);
            }
            if (ruleSetDefList.size() > 0) {
                Object[] ruleSetDefs = new VWRuleSetDefinition[ruleSetDefList.size()];
                ruleSetDefList.copyInto(ruleSetDefs);
                return ruleSetDefs;
            }
        }
        return null;
    }

    public VWRuleSetDefinition[] getRuleSets() {
        if (this.m_ruleSetDefs == null) {
            int nFlags = 1;
            if (this.m_bShowInheritedProperties) {
                nFlags |= 2;
            }
            this.m_ruleSetDefs = this.getRuleSets(nFlags);
        }
        return this.m_ruleSetDefs;
    }

    public VWRuleSetDefinition[] getRuleSets(int nFlags) {
        Vector<VWRuleSetDefinition> ruleSetList = new Vector<VWRuleSetDefinition>();
        if ((nFlags & 2) != 0 && this.m_baseWorkflowDefinition != null) {
            this.getRuleSetsFromWorkflow(this.m_baseWorkflowDefinition, ruleSetList);
        }
        if ((nFlags & 1) != 0 && this.m_workflowDefinition != null) {
            this.getRuleSetsFromWorkflow(this.m_workflowDefinition, ruleSetList);
        }
        Object[] ruleSetDefs = null;
        if (ruleSetList != null && ruleSetList.size() > 0) {
            ruleSetDefs = new VWRuleSetDefinition[ruleSetList.size()];
            ruleSetList.copyInto(ruleSetDefs);
        }
        return ruleSetDefs;
    }

    public void resetRuleSetCache() {
        this.m_ruleSetDefs = null;
    }

    public VWSchema getSchema(String name) {
        VWSchema schemaDef = null;
        if (this.m_workflowDefinition != null && (schemaDef = this.getSchemaFromWorkflow(this.m_workflowDefinition, name)) != null) {
            return schemaDef;
        }
        if (this.m_baseWorkflowDefinition != null) {
            schemaDef = this.getSchemaFromWorkflow(this.m_baseWorkflowDefinition, name);
        }
        return schemaDef;
    }

    public VWSchema[] getSchemas() {
        if (this.m_schemaDefs == null) {
            int nFlags = 1;
            if (this.m_bShowInheritedProperties) {
                nFlags |= 2;
            }
            this.m_schemaDefs = this.getSchemas(nFlags);
        }
        return this.m_schemaDefs;
    }

    public VWSchema[] getSchemas(int nFlags) {
        Vector<VWSchema> schemaList = new Vector<VWSchema>();
        if ((nFlags & 2) != 0 && this.m_baseWorkflowDefinition != null) {
            this.getSchemasFromWorkflow(this.m_baseWorkflowDefinition, schemaList);
        }
        if ((nFlags & 1) != 0 && this.m_workflowDefinition != null) {
            this.getSchemasFromWorkflow(this.m_workflowDefinition, schemaList);
        }
        Object[] schemaDefs = null;
        if (schemaList != null && schemaList.size() > 0) {
            schemaDefs = new VWSchema[schemaList.size()];
            schemaList.copyInto(schemaDefs);
        }
        return schemaDefs;
    }

    public void resetSchemaCache() {
        this.m_schemaDefs = null;
    }

    @Override
    public VWWebServiceUtils getWebServiceUtils() {
        if (this.m_webServiceUtils == null) {
            this.m_webServiceUtils = new VWWebServiceUtils(this);
        }
        return this.m_webServiceUtils;
    }

    public void setWorkflowDefinitions(VWWorkflowDefinition workflowDef, VWWorkflowDefinition baseWorkflowDef) {
        this.m_workflowDefinition = workflowDef;
        this.m_baseWorkflowDefinition = baseWorkflowDef;
        this.m_fieldDefs = null;
        this.m_milestoneDefs = null;
        this.m_partnerLinkDefs = null;
        this.m_ruleSetDefs = null;
        this.m_schemaDefs = null;
        if (this.m_webServiceUtils != null) {
            this.m_webServiceUtils.reset();
        }
    }

    public VWMapCache getMapCache() {
        return this.m_mapCache;
    }

    public void setMapCache(VWMapCache mapCache) {
        this.m_mapCache = mapCache;
        this.setCurrentMapEditable(this.m_mapCache.isEditable("Workflow"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VWMapDefinition createMapDefinition(Object eventSource, String newName, JComponent uiContainer) {
        block8: {
            VWMapDefinition vWMapDefinition;
            try {
                try {
                    VWMap mainMap;
                    VWMapCache mapCache = this.getMapCache();
                    if (mapCache != null && mapCache.get(newName, true) != null) {
                        String message = VWResource.s_mapExists.toString(newName);
                        VWMessageDialog.showOptionDialog(this.getMainContainer(), message, 1);
                        VWMapDefinition vWMapDefinition2 = null;
                        Object var9_10 = null;
                        this.restoreDefaultCursor(uiContainer);
                        return vWMapDefinition2;
                    }
                    this.displayWaitCursor(uiContainer);
                    VWMapDefinition newMapDef = this.getWorkflowDefinition().createMap(newName);
                    if (newMapDef == null) break block8;
                    this.setDirty();
                    if (mapCache != null && (mainMap = mapCache.get("Workflow", true)) != null) {
                        mapCache.addCurrentMap(new VWMap(mainMap.getWorkflowPane(), newMapDef));
                        Vector<VWMapDefinition> eventParams = new Vector<VWMapDefinition>();
                        eventParams.addElement(newMapDef);
                        this.getMapChangeEventNotifier().notifyMapChange(new VWMapChangedEvent(eventSource, 516, eventParams));
                    }
                    vWMapDefinition = newMapDef;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.getMainContainer(), ex.getLocalizedMessage(), 1);
                    Object var9_13 = null;
                    this.restoreDefaultCursor(uiContainer);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                this.restoreDefaultCursor(uiContainer);
                throw throwable;
            }
            Object var9_11 = null;
            this.restoreDefaultCursor(uiContainer);
            return vWMapDefinition;
        }
        Object var9_12 = null;
        this.restoreDefaultCursor(uiContainer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWMapDefinition deleteMapDefinition(Object eventSource, String mapName, JComponent uiContainer) {
        try {
            this.displayWaitCursor(uiContainer);
            VWMapDefinition vwMapDef = this.getWorkflowDefinition().getMap(mapName);
            if (vwMapDef != null) {
                this.getWorkflowDefinition().deleteMap(mapName);
                this.setDirty();
                VWMapCache mapCache = this.getMapCache();
                if (mapCache != null) {
                    mapCache.remove(mapName);
                }
                Vector<String> eventParams = new Vector<String>();
                eventParams.addElement(vwMapDef.getName());
                this.handleRemovedMap(eventParams);
                this.getMapChangeEventNotifier().notifyMapChange(new VWMapChangedEvent(eventSource, 517, eventParams));
            }
            VWMapDefinition vWMapDefinition = vwMapDef;
            Object var8_8 = null;
            this.restoreDefaultCursor(uiContainer);
            return vWMapDefinition;
        }
        catch (Exception ex) {
            try {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.getMainContainer(), ex.getLocalizedMessage(), 1);
                Object var8_9 = null;
                this.restoreDefaultCursor(uiContainer);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.restoreDefaultCursor(uiContainer);
                throw throwable;
            }
        }
        return null;
    }

    public VWMapDefinition getMapDefinition(String mapName) {
        VWMap vwMap;
        if (this.m_mapCache != null && (vwMap = this.m_mapCache.get(mapName, true)) != null) {
            return vwMap.getMapDefinition();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWMapDefinition overrideMapDefinition(Object eventSource, String baseMapName, JComponent uiContainer) {
        try {
            this.displayWaitCursor(uiContainer);
            VWMapDefinition copyOfBaseMapDef = this.getCopyOfBaseWorkflowMap(baseMapName);
            if (copyOfBaseMapDef != null) {
                VWMap baseVWMap;
                VWMapCache mapCache;
                this.getWorkflowDefinition().insertMap(copyOfBaseMapDef);
                this.setDirty();
                if (this.m_designerCoreData.getSolutionHelper() != null) {
                    VWSystemConfiguration sourceConfig = this.m_designerCoreData.getSessionInfo().getSession().fetchSystemConfiguration();
                    VWSystemConfiguration destConfig = this.m_designerCoreData.getDataDictionary().getSystemConfiguration();
                    this.addMapResourcesToConfig(copyOfBaseMapDef, sourceConfig, destConfig);
                    this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 756, Boolean.TRUE);
                }
                if ((mapCache = this.getMapCache()) != null && (baseVWMap = mapCache.getBaseMap(baseMapName)) != null) {
                    VWMap map = new VWMap(baseVWMap.getWorkflowPane(), copyOfBaseMapDef);
                    mapCache.addCurrentMap(map);
                    Vector<VWMapDefinition> eventParams = new Vector<VWMapDefinition>();
                    eventParams.addElement(copyOfBaseMapDef);
                    this.getMapChangeEventNotifier().notifyMapChange(new VWMapChangedEvent(eventSource, 516, eventParams));
                }
            }
            VWMapDefinition vWMapDefinition = copyOfBaseMapDef;
            Object var10_10 = null;
            this.restoreDefaultCursor(uiContainer);
            return vWMapDefinition;
        }
        catch (Exception ex) {
            try {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.getMainContainer(), ex.getLocalizedMessage(), 1);
                Object var10_11 = null;
                this.restoreDefaultCursor(uiContainer);
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.restoreDefaultCursor(uiContainer);
                throw throwable;
            }
        }
        return null;
    }

    public void setCurrentMapEditable(boolean isCurrentMapEditable) {
        this.m_isCurrentMapEditable = isCurrentMapEditable;
    }

    public boolean isCurrentMapEditable() {
        return this.m_isCurrentMapEditable;
    }

    public VWSessionInfo getSessionInfo() {
        if (this.m_designerCoreData != null) {
            return this.m_designerCoreData.getSessionInfo();
        }
        return null;
    }

    public VWDesignerCoreData getDesignerCoreData() {
        return this.m_designerCoreData;
    }

    @Override
    public boolean getShowParticipants() {
        VWSessionInfo sessionInfo = this.getSessionInfo();
        if (sessionInfo != null) {
            return sessionInfo.getShowParticipants();
        }
        return true;
    }

    public void displayWaitCursor(JComponent component) {
        JRootPane rootPane;
        if (component != null && (rootPane = component.getRootPane()) != null) {
            rootPane.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void restoreDefaultCursor(JComponent component) {
        JRootPane rootPane;
        if (component != null && (rootPane = component.getRootPane()) != null) {
            rootPane.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void updateWorkflowBaseClass(String theNewBaseWorkClassName) throws VWException {
        String oldBaseWorkClassName = null;
        VWWorkflowDefinition theNewBaseWorkflowDefinition = null;
        try {
            if (this.m_workflowDefinition != null) {
                ArrayList<VWWorkflowSignature> parentSignatureList = VWClassFactory.VWWorkflowDefinition_fetchParentWorkflowSignatures(theNewBaseWorkClassName, this.m_designerCoreData.getSessionInfo().getSession(), this.m_workflowDefinition, 234L);
                if (parentSignatureList != null) {
                    String wflName = this.m_workflowDefinition.getName();
                    for (int i = 0; i < parentSignatureList.size(); ++i) {
                        if (VWStringUtils.compare(wflName, parentSignatureList.get(i).getName()) != 0) continue;
                        VWMessageDialog.showOptionDialog(this.getMainContainer(), VWResource.s_unsuitableBaseWorkClass.toString(theNewBaseWorkClassName), 1);
                        return;
                    }
                }
                oldBaseWorkClassName = this.m_workflowDefinition.getBaseWorkClassName();
                this.m_workflowDefinition.setBaseWorkClassName(theNewBaseWorkClassName);
                theNewBaseWorkflowDefinition = this.m_designerCoreData.fetchBaseWorkflowDefinition(this.m_workflowDefinition);
                if (theNewBaseWorkflowDefinition != null) {
                    this.m_workflowDefinition.setBaseWorkClassName(theNewBaseWorkClassName);
                    this.m_baseWorkflowDefinition = theNewBaseWorkflowDefinition;
                    this.m_workflowDefinition.setBaseWorkClassName(theNewBaseWorkflowDefinition.getName());
                    this.m_workflowDefinition.setDeadline(theNewBaseWorkflowDefinition.getDeadline());
                    this.m_workflowDefinition.setReminder(theNewBaseWorkflowDefinition.getReminder());
                    this.m_workflowDefinition.setRosterName(theNewBaseWorkflowDefinition.getRosterName());
                    this.m_workflowDefinition.setEventLogName(theNewBaseWorkflowDefinition.getEventLogName());
                    this.m_workflowDefinition.setTag(theNewBaseWorkflowDefinition.getTag());
                    this.m_workflowDefinition.setDisableEmailNotification(theNewBaseWorkflowDefinition.getDisableEmailNotification());
                    String mainAttName = theNewBaseWorkflowDefinition.getMainAttachmentName();
                    if (mainAttName != null && mainAttName.length() > 2) {
                        this.m_workflowDefinition.setMainAttachmentName(mainAttName);
                    } else {
                        this.m_workflowDefinition.setMainAttachmentName(null);
                    }
                    VWFieldDefinition fieldDef = this.getFieldFromWorkflow(theNewBaseWorkflowDefinition, "F_CaseFolder");
                    if (fieldDef != null) {
                        fieldDef = this.getFieldFromWorkflow(this.m_workflowDefinition, "F_CaseFolder");
                        if (fieldDef == null && (fieldDef = this.addLocalField("F_CaseFolder", new VWGuid())) != null) {
                            fieldDef.setRequiredClass(new VWGuid());
                        }
                    } else {
                        this.removeLocalField("F_CaseFolder");
                    }
                    if ((fieldDef = this.getFieldFromWorkflow(theNewBaseWorkflowDefinition, "F_CaseTask")) != null) {
                        fieldDef = this.getFieldFromWorkflow(this.m_workflowDefinition, "F_CaseTask");
                        if (fieldDef == null && (fieldDef = this.addLocalField("F_CaseTask", new VWGuid())) != null) {
                            fieldDef.setRequiredClass(new VWGuid());
                        }
                    } else {
                        this.removeLocalField("F_CaseTask");
                    }
                    this.m_workflowDefinition.setIncomingWSAttachmentFolder(theNewBaseWorkflowDefinition.getIncomingWSAttachmentFolder());
                    this.m_workflowDefinition.setValidateUsingSchema(theNewBaseWorkflowDefinition.getValidateUsingSchema());
                    this.getMapChangeEventNotifier().notifyMapChange(103);
                    this.setDirty();
                } else if (oldBaseWorkClassName != null) {
                    this.m_workflowDefinition.setBaseWorkClassName(oldBaseWorkClassName);
                }
            }
        }
        catch (Exception ex) {
            if (oldBaseWorkClassName != null && theNewBaseWorkflowDefinition == null) {
                this.m_workflowDefinition.setBaseWorkClassName(oldBaseWorkClassName);
            }
            VWDebug.logException(ex);
            String message = null;
            message = ex.getLocalizedMessage() != null ? VWResource.s_cannotSetBaseWorkClass.toString(ex.getLocalizedMessage()) : VWResource.s_cannotSetBaseWorkClass.toString("");
            VWMessageDialog.showOptionDialog(this.getMainContainer(), message, 1);
        }
    }

    public void removeReferences() {
        this.removeListeners();
        this.m_designerCoreData = null;
        this.m_workflowDefinition = null;
        this.m_baseWorkflowDefinition = null;
        this.m_fieldDefs = null;
        this.m_milestoneDefs = null;
        this.m_partnerLinkDefs = null;
        this.m_ruleSetDefs = null;
        this.m_schemaDefs = null;
        if (this.m_webServiceUtils != null) {
            this.m_webServiceUtils.reset();
            this.m_webServiceUtils = null;
        }
    }

    public void removeListeners() {
        if (this.m_mapChangeEventNotifier != null) {
            this.m_mapChangeEventNotifier.releaseReferences();
            this.m_mapChangeEventNotifier = null;
        }
        if (this.m_propertyChangeEventNotifier != null) {
            this.m_propertyChangeEventNotifier.releaseReferences();
            this.m_propertyChangeEventNotifier = null;
        }
        if (this.m_selectionChangeEventNotifier != null) {
            this.m_selectionChangeEventNotifier.releaseReferences();
            this.m_selectionChangeEventNotifier = null;
        }
        if (this.m_tableActionEventNotifier != null) {
            this.m_tableActionEventNotifier.releaseReferences();
            this.m_tableActionEventNotifier = null;
        }
        if (this.m_toolbarActionNotifier != null) {
            this.m_toolbarActionNotifier.releaseReferences();
            this.m_toolbarActionNotifier = null;
        }
    }

    public VWMapChangeEventNotifier getMapChangeEventNotifier() {
        if (this.m_mapChangeEventNotifier == null) {
            this.m_mapChangeEventNotifier = new VWMapChangeEventNotifier();
        }
        return this.m_mapChangeEventNotifier;
    }

    public VWPropertyChangeEventNotifier getPropertyChangeEventNotifier() {
        if (this.m_propertyChangeEventNotifier == null) {
            this.m_propertyChangeEventNotifier = new VWPropertyChangeEventNotifier();
        }
        return this.m_propertyChangeEventNotifier;
    }

    public VWSelectionChangeEventNotifier getSelectionChangeEventNotifier() {
        if (this.m_selectionChangeEventNotifier == null) {
            this.m_selectionChangeEventNotifier = new VWSelectionChangeEventNotifier();
        }
        return this.m_selectionChangeEventNotifier;
    }

    public VWTableActionEventNotifier getTableActionEventNotifier() {
        if (this.m_tableActionEventNotifier == null) {
            this.m_tableActionEventNotifier = new VWTableActionEventNotifier();
        }
        return this.m_tableActionEventNotifier;
    }

    public VWToolbarActionNotifier getToolbarActionNotifier() {
        if (this.m_toolbarActionNotifier == null) {
            this.m_toolbarActionNotifier = new VWToolbarActionNotifier();
        }
        return this.m_toolbarActionNotifier;
    }

    public VWWorkflowCollectionDefinition getWorkflowCollectionDefinition() {
        if (this.m_designerCoreData != null) {
            return this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition();
        }
        return null;
    }

    public VWMapAttribs getMapAttributes() {
        if (this.m_designerCoreData != null) {
            return this.m_designerCoreData.getMapAttributes();
        }
        return null;
    }

    public VWDesignerPropertyPane getWorkflowPropertyPane() {
        return this.m_workflowPropertyPane;
    }

    public void setWorkflowPropertyPane(VWDesignerPropertyPane propertyPane) {
        this.m_workflowPropertyPane = propertyPane;
    }

    public void initializeCEObjectInfo(VWFieldDefinition fieldDef) {
        try {
            CEObjectInfo ceObjInfo;
            CEObjectInfoCache ceObjectCache;
            if (fieldDef == null || fieldDef.getFieldType() != 512 || fieldDef.getCEObjectInfo() != null) {
                return;
            }
            VWGuid requiredClass = fieldDef.getRequiredClass();
            if (requiredClass == null) {
                return;
            }
            if (this.m_designerCoreData != null && (ceObjectCache = this.m_designerCoreData.getCEObjectInfoCache()) != null && (ceObjInfo = ceObjectCache.getCEClassDefinition(requiredClass)) != null) {
                VWClassFactory.VWFieldDefinition_setCEObjectInfo(fieldDef, ceObjInfo, 234L);
            }
        }
        catch (VWException ex) {
            ex.printStackTrace();
        }
    }

    public void addResourcesToConfig(VWWorkflowDefinition newWflDef) {
        try {
            VWMapDefinition[] mapDefs;
            String eventLogName;
            String rosterName;
            VWSystemConfiguration sourceConfig = null;
            VWSystemConfiguration destConfig = this.m_designerCoreData.getDataDictionary().getSystemConfiguration();
            if (this.m_designerCoreData.getSolutionHelper() != null) {
                sourceConfig = this.m_designerCoreData.getSessionInfo().getSession().fetchSystemConfiguration();
            }
            if ((rosterName = newWflDef.getRosterName()) != null && destConfig.getRosterDefinition(rosterName) == null) {
                VWRosterDefinition rosterDef;
                destConfig.createRosterDefinition(rosterName);
                if (sourceConfig != null && (rosterDef = sourceConfig.getRosterDefinition(rosterName)) != null) {
                    destConfig.updateRosterDefinition(rosterDef);
                    VWClassFactory.VWRosterDefinition_setHasChanged(rosterDef, true, 234L);
                }
            }
            if ((eventLogName = newWflDef.getEventLogName()) != null && destConfig.getLogDefinition(eventLogName) == null) {
                VWLogDefinition eventLogDef;
                destConfig.createLogDefinition(eventLogName);
                if (sourceConfig != null && (eventLogDef = sourceConfig.getLogDefinition(eventLogName)) != null) {
                    destConfig.updateLogDefinition(eventLogDef);
                    VWClassFactory.VWLogDefinition_setHasChanged(eventLogDef, true, 234L);
                }
            }
            if ((mapDefs = newWflDef.getMaps()) != null) {
                for (int nMapIndex = 0; nMapIndex < mapDefs.length; ++nMapIndex) {
                    this.addMapResourcesToConfig(mapDefs[nMapIndex], sourceConfig, destConfig);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public void addMapResourcesToConfig(VWMapDefinition mapDef, VWSystemConfiguration sourceConfig, VWSystemConfiguration destConfig) throws VWException {
        VWMapNode[] mapNodes = mapDef.getSteps();
        if (mapNodes != null) {
            for (int nNodeIndex = 0; nNodeIndex < mapNodes.length; ++nNodeIndex) {
                VWMapNode stepDef;
                if (mapNodes[nNodeIndex] instanceof VWStepDefinition) {
                    VWStepProcessorInfoDefinition sourceStepProcDef;
                    String stepProcName;
                    stepDef = (VWStepDefinition)mapNodes[nNodeIndex];
                    String queueName = ((VWStepDefinition)stepDef).getQueueName();
                    if (queueName != null && destConfig.getQueueDefinition(queueName) == null) {
                        if (VWStringUtils.compare(queueName, "Conductor") == 0) {
                            if (this.m_designerCoreData.getSolutionHelper() != null) {
                                VWQueueDefinition queueDef = destConfig.createQueueDefinition(queueName, 1);
                                queueDef = destConfig.getQueueDefinition(queueName);
                                queueDef.createOperation("Review");
                            }
                        } else {
                            VWQueueDefinition queueDef;
                            destConfig.createQueueDefinition(queueName, 1);
                            if (sourceConfig != null && (queueDef = sourceConfig.getQueueDefinition(queueName)) != null) {
                                destConfig.updateQueueDefinition(queueDef);
                                VWClassFactory.VWQueueDefinition_setHasChanged(queueDef, true, 234L);
                            }
                        }
                    }
                    if ((stepProcName = ((VWStepDefinition)stepDef).getRequestedInterface()) == null || destConfig.getStepProcessorInfoDefinition(stepProcName) != null || sourceConfig == null || (sourceStepProcDef = sourceConfig.getStepProcessorInfoDefinition(stepProcName)) == null) continue;
                    VWStepProcessorInfoDefinition newStepProcDef = destConfig.createStepProcessorInfoDefinition();
                    newStepProcDef.setName(sourceStepProcDef.getName());
                    newStepProcDef.setHasChanged(true);
                    newStepProcDef.setHeight(sourceStepProcDef.getHeight());
                    newStepProcDef.setWidth(sourceStepProcDef.getWidth());
                    newStepProcDef.setProcessorType(sourceStepProcDef.getProcessorType());
                    newStepProcDef.setApplicationName(sourceStepProcDef.getApplicationName());
                    newStepProcDef.setAppType(sourceStepProcDef.getAppType());
                    newStepProcDef.setLocations(sourceStepProcDef.getLocations());
                    continue;
                }
                stepDef = (VWCompoundStepDefinition)mapNodes[nNodeIndex];
                VWInstructionDefinition[] instructionDefs = ((VWCompoundStepDefinition)stepDef).getInstructions();
                if (instructionDefs == null) continue;
                block4: for (int nInstructionIndex = 0; nInstructionIndex < instructionDefs.length; ++nInstructionIndex) {
                    switch (instructionDefs[nInstructionIndex].getAction()) {
                        case 23: {
                            VWQueueDefinition queueDef;
                            String queueName = VWInstruction.ExecuteInstructionGetQueueName(instructionDefs[nInstructionIndex]);
                            if (queueName == null || destConfig.getQueueDefinition(queueName) != null || sourceConfig == null || (queueDef = sourceConfig.getQueueDefinition(queueName)) == null) continue block4;
                            destConfig.createQueueDefinition(queueName, 1);
                            destConfig.updateQueueDefinition(queueDef);
                            VWClassFactory.VWQueueDefinition_setHasChanged(queueDef, true, 234L);
                            continue block4;
                        }
                    }
                }
            }
        }
    }

    @Override
    public Frame getMainContainer() {
        VWSessionInfo sessionInfo = this.getSessionInfo();
        if (sessionInfo != null) {
            return sessionInfo.getParentFrame();
        }
        return null;
    }

    @Override
    public VWSession getVWSession() {
        VWSessionInfo sessionInfo = this.getSessionInfo();
        if (sessionInfo != null) {
            return sessionInfo.getSession();
        }
        return null;
    }

    @Override
    public VWWorkflowDefinition getWorkflowDefinition() {
        return this.m_workflowDefinition;
    }

    @Override
    public VWWorkflowDefinition getBaseWorkflowDefinition() {
        return this.m_baseWorkflowDefinition;
    }

    @Override
    public boolean isProcessSimulation() {
        return false;
    }

    private VWFieldDefinition addLocalField(String fieldName, Object fieldValue) {
        VWFieldDefinition fieldDef = null;
        try {
            fieldDef = this.getFieldFromWorkflow(this.m_workflowDefinition, fieldName);
            if (fieldDef == null) {
                fieldDef = this.m_workflowDefinition.createFieldUsingObject(fieldName, fieldValue);
            }
        }
        catch (VWException ex) {
            // empty catch block
        }
        return fieldDef;
    }

    private void removeLocalField(String fieldName) {
        try {
            VWFieldDefinition fieldDef = this.getFieldFromWorkflow(this.m_workflowDefinition, fieldName);
            if (fieldDef != null) {
                this.m_workflowDefinition.deleteField(fieldName);
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
    }

    private VWFieldDefinition getFieldFromWorkflow(VWWorkflowDefinition workflowDefinition, String name) {
        try {
            if (workflowDefinition != null && name != null && name.length() > 0) {
                VWFieldDefinition fieldDef = workflowDefinition.getField(name);
                if (fieldDef != null && fieldDef.getFieldType() == 512) {
                    this.initializeCEObjectInfo(fieldDef);
                }
                return fieldDef;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void getFieldsFromWorkflow(VWWorkflowDefinition workflowDefinition, Vector<VWFieldDefinition> fieldList) {
        try {
            VWFieldDefinition[] fieldDefs;
            if (workflowDefinition != null && fieldList != null && (fieldDefs = workflowDefinition.getFields()) != null && fieldDefs.length > 0) {
                Object[] currentFieldList = null;
                if (fieldList.size() > 0) {
                    currentFieldList = new VWFieldDefinition[fieldList.size()];
                    fieldList.copyInto(currentFieldList);
                }
                for (int i = 0; i < fieldDefs.length; ++i) {
                    if (fieldDefs[i] == null || fieldDefs[i].getName().startsWith(F_UNDERSCORE)) continue;
                    boolean bFound = false;
                    if (currentFieldList != null) {
                        for (int y = 0; y < currentFieldList.length; ++y) {
                            if (VWStringUtils.compare(fieldDefs[i].getName(), ((VWFieldDefinition)currentFieldList[y]).getName()) != 0) continue;
                            bFound = true;
                            break;
                        }
                    }
                    if (bFound) continue;
                    fieldList.addElement(fieldDefs[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWMapDefinition getCopyOfBaseWorkflowMap(String mapName) throws Exception {
        VWWorkflowDefinition baseWlfDef;
        String baseWorkflowClassName;
        VWWorkflowDefinition workflowDef = this.getWorkflowDefinition();
        if (workflowDef != null && (baseWorkflowClassName = workflowDef.getBaseWorkClassName()) != null && (baseWlfDef = this.m_designerCoreData.fetchBaseWorkflowDefinition(this.m_workflowDefinition)) != null) {
            return baseWlfDef.getMap(mapName);
        }
        return null;
    }

    private VWMilestoneDefinition getMilestoneFromWorkflow(VWWorkflowDefinition workflowDefinition, String name) {
        try {
            if (workflowDefinition != null && name != null && name.length() > 0) {
                return workflowDefinition.getMilestone(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void getMilestonesFromWorkflow(VWWorkflowDefinition workflowDefinition, Vector<VWMilestoneDefinition> milestoneList) {
        try {
            VWMilestoneDefinition[] milestoneDefs;
            if (workflowDefinition != null && milestoneList != null && (milestoneDefs = workflowDefinition.getMilestones()) != null && milestoneDefs.length > 0) {
                Object[] currentMilestoneList = null;
                if (milestoneList.size() > 0) {
                    currentMilestoneList = new VWMilestoneDefinition[milestoneList.size()];
                    milestoneList.copyInto(currentMilestoneList);
                }
                for (int i = 0; i < milestoneDefs.length; ++i) {
                    if (milestoneDefs[i] == null || milestoneDefs[i].getName().startsWith(F_UNDERSCORE)) continue;
                    boolean bFound = false;
                    if (currentMilestoneList != null) {
                        for (int y = 0; y < currentMilestoneList.length; ++y) {
                            if (VWStringUtils.compare(milestoneDefs[i].getName(), ((VWMilestoneDefinition)currentMilestoneList[y]).getName()) != 0) continue;
                            bFound = true;
                            break;
                        }
                    }
                    if (bFound) continue;
                    milestoneList.addElement(milestoneDefs[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWPartnerLinkDefinition getPartnerLinkFromWorkflow(VWWorkflowDefinition workflowDefinition, String name) {
        try {
            if (workflowDefinition != null && name != null && name.length() > 0) {
                return workflowDefinition.getPartnerLink(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void getPartnerLinksFromWorkflow(VWWorkflowDefinition workflowDefinition, Vector<VWPartnerLinkDefinition> partnerLinkList) {
        try {
            VWPartnerLinkDefinition[] partnerLinkDefs;
            if (workflowDefinition != null && partnerLinkList != null && (partnerLinkDefs = workflowDefinition.getPartnerLinks()) != null && partnerLinkDefs.length > 0) {
                Object[] currentPartnerLinkList = null;
                if (partnerLinkList.size() > 0) {
                    currentPartnerLinkList = new VWPartnerLinkDefinition[partnerLinkList.size()];
                    partnerLinkList.copyInto(currentPartnerLinkList);
                }
                for (int i = 0; i < partnerLinkDefs.length; ++i) {
                    if (partnerLinkDefs[i] == null || partnerLinkDefs[i].getName().startsWith(F_UNDERSCORE)) continue;
                    boolean bFound = false;
                    if (currentPartnerLinkList != null) {
                        for (int y = 0; y < currentPartnerLinkList.length; ++y) {
                            if (VWStringUtils.compare(partnerLinkDefs[i].getName(), ((VWPartnerLinkDefinition)currentPartnerLinkList[y]).getName()) != 0) continue;
                            bFound = true;
                            break;
                        }
                    }
                    if (bFound) continue;
                    partnerLinkList.addElement(partnerLinkDefs[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWRuleSetDefinition getRuleSetFromWorkflow(VWWorkflowDefinition workflowDefinition, String name) {
        try {
            VWRuleSetDefinition[] ruleSetDefs;
            if (workflowDefinition != null && name != null && name.length() > 0 && (ruleSetDefs = workflowDefinition.getRuleSets()) != null && ruleSetDefs.length > 0) {
                for (int i = 0; i < ruleSetDefs.length; ++i) {
                    if (VWStringUtils.compare(ruleSetDefs[i].getName(), name) != 0) continue;
                    return ruleSetDefs[i];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void getRuleSetsFromWorkflow(VWWorkflowDefinition workflowDefinition, Vector<VWRuleSetDefinition> ruleSetList) {
        try {
            VWRuleSetDefinition[] ruleSetDefs;
            if (workflowDefinition != null && ruleSetList != null && (ruleSetDefs = workflowDefinition.getRuleSets()) != null && ruleSetDefs.length > 0) {
                Object[] currentRuleSetList = null;
                if (ruleSetList.size() > 0) {
                    currentRuleSetList = new VWRuleSetDefinition[ruleSetList.size()];
                    ruleSetList.copyInto(currentRuleSetList);
                }
                for (int i = 0; i < ruleSetDefs.length; ++i) {
                    if (ruleSetDefs[i] == null || ruleSetDefs[i].getName().startsWith(F_UNDERSCORE)) continue;
                    boolean bFound = false;
                    if (currentRuleSetList != null) {
                        for (int y = 0; y < currentRuleSetList.length; ++y) {
                            if (VWStringUtils.compare(ruleSetDefs[i].getName(), ((VWRuleSetDefinition)currentRuleSetList[y]).getName()) != 0) continue;
                            bFound = true;
                            break;
                        }
                    }
                    if (bFound) continue;
                    ruleSetList.addElement(ruleSetDefs[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWSchema getSchemaFromWorkflow(VWWorkflowDefinition workflowDefinition, String name) {
        try {
            if (workflowDefinition != null && name != null && name.length() > 0) {
                return workflowDefinition.getSchema(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void getSchemasFromWorkflow(VWWorkflowDefinition workflowDefinition, Vector<VWSchema> schemaList) {
        try {
            VWSchema[] schemaDefs;
            if (workflowDefinition != null && schemaList != null && (schemaDefs = workflowDefinition.getSchemas()) != null && schemaDefs.length > 0) {
                Object[] currentSchemaList = null;
                if (schemaList.size() > 0) {
                    currentSchemaList = new VWSchema[schemaList.size()];
                    schemaList.copyInto(currentSchemaList);
                }
                for (int i = 0; i < schemaDefs.length; ++i) {
                    if (schemaDefs[i] == null || schemaDefs[i].getName().startsWith(F_UNDERSCORE)) continue;
                    boolean bFound = false;
                    if (currentSchemaList != null) {
                        for (int y = 0; y < currentSchemaList.length; ++y) {
                            if (VWStringUtils.compare(schemaDefs[i].getName(), ((VWSchema)currentSchemaList[y]).getName()) != 0) continue;
                            bFound = true;
                            break;
                        }
                    }
                    if (bFound) continue;
                    schemaList.addElement(schemaDefs[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void handleRemovedMap(Vector changedItems) {
        try {
            if (changedItems == null || changedItems.isEmpty()) {
                return;
            }
            VWWorkflowDefinition wfDef = this.getWorkflowDefinition();
            if (wfDef == null) {
                return;
            }
            VWMapDefinition[] mapDefs = wfDef.getMaps();
            if (mapDefs == null) {
                return;
            }
            Object[] removedMapNames = new String[changedItems.size()];
            changedItems.copyInto(removedMapNames);
            for (int i = 0; i < mapDefs.length; ++i) {
                VWMapNode[] mapNodes = mapDefs[i].getSteps();
                if (mapNodes == null) continue;
                block7: for (int j = 0; j < mapNodes.length; ++j) {
                    switch (VWStepUtils.getStepType(mapNodes[j])) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            int k;
                            for (k = 0; k < removedMapNames.length; ++k) {
                                VWInstructionDefinition[] instructionDefs;
                                VWCompoundStepDefinition stepDef;
                                Object deletedMapName = removedMapNames[k];
                                if (this.getMapCache().isBaseMapExist((String)deletedMapName) || (stepDef = (VWCompoundStepDefinition)mapNodes[j]) == null || (instructionDefs = stepDef.getInstructions()) == null) continue;
                                for (int l = 0; l < instructionDefs.length; ++l) {
                                    String mapName;
                                    if (instructionDefs[l].getAction() != 5 || VWStringUtils.compare(mapName = VWInstruction.CallInstructionGetSubmap(instructionDefs[l]), (String)deletedMapName) != 0) continue;
                                    VWInstruction.CallInstructionSetSubmap(instructionDefs[l], null);
                                }
                            }
                            continue block7;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            int k;
                            for (k = 0; k < removedMapNames.length; ++k) {
                                String mapName;
                                VWStepDefinition stepDef;
                                if (this.getMapCache().isBaseMapExist((String)removedMapNames[k]) || (stepDef = (VWStepDefinition)mapNodes[j]) == null || VWStringUtils.compare(mapName = stepDef.getDeadlineMap(), (String)removedMapNames[k]) != 0) continue;
                                stepDef.setDeadlineMap(null);
                            }
                            continue block7;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

